/*
 * g3g_dbusappbase.h
 *
 *  Created on: Sep 18, 2012
 *      Author: rjk2hi
 */

#ifndef G3G_DBUSAPPBASE_H_
#define G3G_DBUSAPPBASE_H_


#ifndef DISABLE_DISPATCHER_THREAD
#include <pthread.h>
#endif

class g3g_dbusappbase
{
private:
	static g3g_dbusappbase* 				m_poSelf;//Self pointer

	g3g_dbusappbase							(const g3g_dbusappbase&);//Private constructors
	void operator=							(const g3g_dbusappbase & );//Private constructors
	static void vHandleProcTermSignal		(int signal);//Process terminate signal

protected:
	g3g_dbusappbase							();//Constructor for derived classes to invoke
	virtual ~g3g_dbusappbase				();//Destructor

public:
	/*
	 * Pure Virtual Functions
	 */
	virtual bool bOnAppInit					() = 0;//Function triggered to initialize
	virtual void vOnAppClose				() = 0;//Function trigger before termination of application

	bool bStartApp							();
	bool bAppClosed						    () const;

	static g3g_dbusappbase*					poGetPointer();
};

#endif /* G3G_DBUSAPPBASE_H_ */

